//
//  ICFViewController.m
//  Gesture Playground
//
//  Created by Joe Keeley on 2/24/12.
//  Copyright (c) 2012 Explore Systems, Inc. All rights reserved.
//

#import "ICFViewController.h"

@implementation ICFViewController

#pragma mark - UIGestureRecognizerDelegate methods
- (BOOL)gestureRecognizer:(UIGestureRecognizer *)gestureRecognizer shouldRecognizeSimultaneouslyWithGestureRecognizer:(UIGestureRecognizer *)otherGestureRecognizer
{
    return YES;    
}


#pragma mark - UIGestureRecognizer handling methods
- (void)myGestureViewTapped:(UIGestureRecognizer *)tapGestureRecognizer {
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Nastąpiło stuknięcie"
                                                    message:@"Widok myGestureView został stuknięty"
                                                   delegate:nil 
                                          cancelButtonTitle:@"OK, dzięki"
                                          otherButtonTitles:nil];
    [alert show];
}

- (void)myGestureViewSingleTapped:(UIGestureRecognizer *)tapGestureRecognizer {
    NSLog(@"Otrzymano pojedyncze stuknięcie");
}

- (void)myGestureViewDoubleTapped:(UIGestureRecognizer *)doubleTapGestureRecognizer {
    NSLog(@"Otrzymano podwójne stuknięcie");
}

- (void)myGestureViewSoloPinched:(UIPinchGestureRecognizer *)pinchGesture {
    CGFloat pinchScale = [pinchGesture scale];
    
	CGAffineTransform scaleTransform = 	CGAffineTransformMakeScale(pinchScale, pinchScale);
    
	[self.myGestureView setTransform:scaleTransform];
}

- (void)updateViewTransformWithScaleDelta:(CGFloat)scaleDelta andRotationDelta:(CGFloat)rotationDelta;
{
    if (rotationDelta != 0) {
        [self setCurrentRotationDelta:rotationDelta];
    }
    if (scaleDelta != 0) {
        [self setCurrentScaleDelta:scaleDelta];
    }
    CGFloat scaleAmount = [self scaleFactor]+[self currentScaleDelta];
    CGAffineTransform scaleTransform = CGAffineTransformMakeScale(scaleAmount, scaleAmount);
    
    CGFloat rotationAmount = [self rotationFactor]+[self currentRotationDelta];
    CGAffineTransform rotateTransform = CGAffineTransformMakeRotation(rotationAmount);
    
    CGAffineTransform newTransform = CGAffineTransformConcat(scaleTransform, rotateTransform);
    [self.myGestureView setTransform:newTransform];
}

- (void)myGestureViewPinched:(UIPinchGestureRecognizer *)pinchGesture {
    CGFloat newPinchDelta = [pinchGesture scale] - 1; //scale starts at 1.0
    [self updateViewTransformWithScaleDelta:newPinchDelta andRotationDelta:0];
    if ([pinchGesture state] == UIGestureRecognizerStateEnded) {
        [self setScaleFactor:[self scaleFactor] + newPinchDelta];
        [self setCurrentScaleDelta:0.0];
    }
}

- (void)myGestureViewRotated:(UIRotationGestureRecognizer *)rotateGesture {
    CGFloat newRotateRadians = [rotateGesture rotation];
    
    [self updateViewTransformWithScaleDelta:0.0 andRotationDelta:newRotateRadians];
    if ([rotateGesture state] == UIGestureRecognizerStateEnded) {
        CGFloat saveRotation = [self rotationFactor] + newRotateRadians;
        [self setRotationFactor:saveRotation];
        [self setCurrentRotationDelta:0.0];
    }
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Release any cached data, images, etc that aren't in use.
}

#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];

    
    UITapGestureRecognizer *tapRecognizer = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(myGestureViewTapped:)];
    [self.myGestureView addGestureRecognizer:tapRecognizer];
     

    /*
    UIPinchGestureRecognizer *soloPinchRecognizer = [[UIPinchGestureRecognizer alloc] initWithTarget:self action:@selector(myGestureViewSoloPinched:)];
    //[myGestureView addGestureRecognizer:soloPinchRecognizer];
    [[self view] addGestureRecognizer:soloPinchRecognizer];
    */

    
    /*UIPinchGestureRecognizer *pinchRecognizer = [[UIPinchGestureRecognizer alloc] initWithTarget:self action:@selector(myGestureViewPinched:)];
    [pinchRecognizer setDelegate:self];
    [self.myGestureView addGestureRecognizer:pinchRecognizer];
     
    UIRotationGestureRecognizer *rotateRecognizer = [[UIRotationGestureRecognizer alloc] initWithTarget:self action:@selector(myGestureViewRotated:)];
    [rotateRecognizer setDelegate:self];
    [self.myGestureView addGestureRecognizer:rotateRecognizer];*/
    

    /*
    UITapGestureRecognizer *doubleTapRecognizer = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(myGestureViewDoubleTapped:)];
    [doubleTapRecognizer setNumberOfTapsRequired:2];
    [self.myGestureView addGestureRecognizer:doubleTapRecognizer];

    UITapGestureRecognizer *singleTapRecognizer = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(myGestureViewTapped:)];
    [singleTapRecognizer requireGestureRecognizerToFail:doubleTapRecognizer];
    [self.myGestureView addGestureRecognizer:singleTapRecognizer];
    */

    
    //set defaults for scale and rotation
    [self setScaleFactor:1.0];
    [self setRotationFactor:0.0];
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
}

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
}

- (void)viewWillDisappear:(BOOL)animated
{
	[super viewWillDisappear:animated];
}

- (void)viewDidDisappear:(BOOL)animated
{
	[super viewDidDisappear:animated];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Return YES for supported orientations
    return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
}

@end
